﻿################################################################################
## Inicialização
################################################################################

init offset = -1


################################################################################
## Estilos
################################################################################

style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)



################################################################################
## Telas no jogo
################################################################################


## Diga a tela #################################################################
##
## A tela say é usada para exibir o diálogo para o jogador. Ela recebe dois
## parâmetros, who e what, que são o nome do personagem que fala e o texto a ser
## exibido, respectivamente. (O parâmetro who pode ser None (Nenhum) se nenhum
## nome for fornecido).
##
## Essa tela deve criar um texto exibível com o id "what", pois o Ren'Py o
## utiliza para gerenciar a exibição de texto. Ela também pode criar exibíveis
## com id "who" e id "window" para aplicar propriedades de estilo.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "namebox"
                text who id "who"

        text what id "what"


    ## Se houver uma imagem lateral, exiba-a acima do texto. Não exiba na
    ## variante do telefone - não há espaço.
    if not renpy.variant("small"):
        add SideImage() xalign 0.0 yalign 1.0


## Disponibilize a caixa de nome para estilização por meio do objeto Character.
init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    background Image("gui/textbox.png", xalign=0.5, yalign=1.0)

style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos

    adjust_spacing False

## Tela de entrada #############################################################
##
## Essa tela é usada para exibir renpy.input. O parâmetro prompt é usado para
## passar um prompt de texto.
##
## Essa tela deve criar um displayable de entrada com id "input" para aceitar os
## vários parâmetros de entrada.
##
## https://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"

    window:

        vbox:
            xanchor gui.dialogue_text_xalign
            xpos gui.dialogue_xpos
            xsize gui.dialogue_width
            ypos gui.dialogue_ypos

            text prompt style "input_prompt"
            input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")

style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width


## Tela de escolha #############################################################
##
## Essa tela é usada para exibir as opções no jogo apresentadas pela instrução
## de menu. O único parâmetro, itens, é uma lista de objetos, cada um com campos
## de legenda e ação.
##
## https://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action

    # Background do quick menu
    add "gui/quick_menu.png" xalign 0.5 yalign 1.0

style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    yalign 0.48

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.text_properties("choice_button")


## Tela do menu rápido #########################################################
##
## O menu rápido é exibido no jogo para fornecer acesso fácil aos menus fora do
## jogo.

screen quick_menu():

    ## Certifique-se de que isso apareça na parte superior de outras telas.
    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Voltar") action Rollback()
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Inventário") action ShowMenu('inventory')
            textbutton _("Missão") action ShowMenu('mission')
            textbutton _("Salvar") action ShowMenu('save')
            textbutton _("Preferências") action ShowMenu('preferences')
            textbutton _("Sair") action Quit(confirm=True)


## Esse código garante que a tela quick_menu seja exibida no jogo, sempre que o
## jogador não tiver ocultado explicitamente a interface.
init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.text_properties("quick_button")


################################################################################
## Telas do menu principal e do menu do jogo
################################################################################

## Tela de navegação ###########################################################
##
## Essa tela está incluída nos menus principal e do jogo e fornece navegação
## para outros menus e para iniciar o jogo.

screen navigation():

    vbox:
        style_prefix "navigation"

        xpos gui.navigation_xpos
        yalign 0.5

        spacing gui.navigation_spacing

        if main_menu:

            textbutton _("Iniciar") action Start()

        else:

            textbutton _("Histórico") action ShowMenu("history")

            textbutton _("Salvar") action ShowMenu("save")

        textbutton _("Carregar") action ShowMenu("load")

        textbutton _("Preferências") action ShowMenu("preferences")

        if _in_replay:

            textbutton _("Fim da reprodução") action EndReplay(confirm=True)

        elif not main_menu:

            textbutton _("Menu principal") action MainMenu()

        textbutton _("Sobre") action ShowMenu("about")

        if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):

            ## A ajuda não é necessária ou relevante para dispositivos móveis.
            textbutton _("Ajuda") action ShowMenu("help")

        if renpy.variant("pc"):

            ## O botão Sair é proibido no iOS e desnecessário no Android e na
            ## Web.
            textbutton _("Sair") action Quit(confirm=not main_menu)


style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.text_properties("navigation_button")


## Tela do menu principal ######################################################
##
## Usado para exibir o menu principal quando o Ren'Py é iniciado.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    ## Isso garante que qualquer outra tela de menu seja substituída.
    tag menu

    add gui.main_menu_background

    ## Esse quadro vazio escurece o menu principal.
    frame:
        style "main_menu_frame"

    ## A instrução de uso inclui outra tela dentro desta. O conteúdo real do
    ## menu principal está na tela de navegação.
    use navigation

    if gui.show_name:

        vbox:
            style "main_menu_vbox"

            text "[config.name!t]":
                style "main_menu_title"

            text "[config.version]":
                style "main_menu_version"

    ## Frame de apelo
    frame:
        # Posiciona o frame
        xalign 0.95
        yalign 0.12
        # Tamanho do frame
        xsize 580
        # Espaço entre o texto e a borda
        padding (30, 30)

        text _("Olá, aventureiro! Este é um jogo feito de um fã para fãs, completamente livre de anúncios e de vendas de itens. Porém, cada atualização demanda muito tempo e recursos.\nCaso deseje apoiar o projeto, você pode colaborar fazendo uma doação:\n{size=36}{b}{a=https://vanurion.com/donate.html}Clique aqui{/a}{/b}{/size}"):
            text_align 0.5
            size 26

#    ## Caixa de idioma
#    frame:
#        # Posiciona o frame
#        xalign 0.6
#        yalign 1.0
#
#        hbox:
#            spacing 2
#
#            imagebutton:
#                auto "gui/flags/brazil_flag_%s.png"
#                action Language(None)
#
#            imagebutton:
#                auto "gui/flags/united_states_flag_%s.png"
#                action Language("english")


style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 420
    yfill True

    background "gui/overlay/main_menu.png"

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -30

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_version:
    properties gui.text_properties("version")


## Tela do menu do jogo ########################################################
##
## Isso estabelece a estrutura básica comum de uma tela de menu de jogo. Ela
## é chamada com o título da tela e exibe o plano de fundo, o título e a
## navegação.
##
## O parâmetro de rolagem pode ser Nenhum ou um dos parâmetros "viewport"
## ou "vpgrid". Essa tela deve ser usada com um ou mais filhos, que são
## transcluídos (colocados) dentro dela.

screen game_menu(title, scroll=None, yinitial=0.0, spacing=0):

    style_prefix "game_menu"

    if main_menu:
        add gui.main_menu_background
    else:
        add gui.game_menu_background

    frame:
        style "game_menu_outer_frame"

        hbox:

            ## Reserve espaço para a seção de navegação.
            frame:
                style "game_menu_navigation_frame"

            frame:
                style "game_menu_content_frame"

                if scroll == "viewport":

                    viewport:
                        yinitial yinitial
                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        vbox:
                            spacing spacing

                            transclude

                elif scroll == "vpgrid":

                    vpgrid:
                        cols 1
                        yinitial yinitial

                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        spacing spacing

                        transclude

                else:

                    transclude

    use navigation

    textbutton _("Voltar"):
        style "return_button"

        action Return()

    label title

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 45
    top_padding 180

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 420
    yfill True

style game_menu_content_frame:
    left_margin 60
    right_margin 30
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45


## Sobre a tela ################################################################
##
## Essa tela fornece informações de crédito e direitos autorais sobre o jogo e
## Ren'Py.
##
## Não há nada de especial nessa tela e, portanto, ela também serve como exemplo
## de como criar uma tela personalizada.

screen about():

    tag menu

    ## Essa instrução de uso inclui a tela game_menu dentro desta. O filho vbox
    ## é então incluído na janela de visualização dentro da tela game_menu.
    use game_menu(_("Sobre"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]"
            text _("Versão [config.version!t]\n")

            ## gui.about é normalmente definido em options.rpy.
            if gui.about:
                text "[gui.about!t]\n"

            text _("Feito com {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only] .\n\n[renpy.license!t]")


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size


## Carregar e salvar telas #####################################################
##
## Essas telas são responsáveis por permitir que o jogador salve o jogo
## e o carregue novamente. Como elas têm quase tudo em comum, ambas são
## implementadas em termos de uma terceira tela, file_slots.
##
## https://www.renpy.org/doc/html/screen_special.html#save https://
## www.renpy.org/doc/html/screen_special.html#load

screen save():

    tag menu

    use file_slots(_("Salvar"))


screen load():

    tag menu

    use file_slots(_("Carregar"))


screen file_slots(title):

    default page_name_value = FilePageNameInputValue(pattern=_("Página {}"), auto=_("Salvamentos automáticos"), quick=_("Salvamentos rápidos"))

    use game_menu(title):

        fixed:

            ## Isso garante que a entrada receberá o evento enter antes de
            ## qualquer um dos botões.
            order_reverse True

            ## O nome da página, que pode ser editado clicando em um botão.
            button:
                style "page_label"

                key_events True
                xalign 0.5
                action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value

            ## A grade de slots de arquivo.
            grid gui.file_slot_cols gui.file_slot_rows:
                style_prefix "slot"

                xalign 0.5
                yalign 0.5

                spacing gui.slot_spacing

                for i in range(gui.file_slot_cols * gui.file_slot_rows):

                    $ slot = i + 1

                    button:
                        action FileAction(slot)

                        has vbox

                        add FileScreenshot(slot) xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%A, %B %d %Y, %H:%M"), empty=_("slot vazio")):
                            style "slot_time_text"

                        text FileSaveName(slot):
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)

            ## Botões para acessar outras páginas.
            vbox:
                style_prefix "page"

                xalign 0.5
                yalign 1.0

                hbox:
                    xalign 0.5

                    spacing gui.page_spacing

                    textbutton _("<") action FilePagePrevious()
                    key "save_page_prev" action FilePagePrevious()

                    if config.has_autosave:
                        textbutton _("{#auto_page}A") action FilePage("auto")

                    if config.has_quicksave:
                        textbutton _("{#quick_page}Q") action FilePage("quick")

                    ## range(1, 10) fornece os números de 1 a 9.
                    for page in range(1, 10):
                        textbutton "[page]" action FilePage(page)

                    textbutton _(">") action FilePageNext()
                    key "save_page_next" action FilePageNext()

                if config.has_sync:
                    if CurrentScreenName() == "save":
                        textbutton _("Upload Sync"):
                            action UploadSync()
                            xalign 0.5
                    else:
                        textbutton _("Baixar o Sync"):
                            action DownloadSync()
                            xalign 0.5


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75
    ypadding 5

style page_label_text:
    textalign 0.5
    layout "subtitle"
    hover_color gui.hover_color

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.text_properties("page_button")

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.text_properties("slot_button")


## Tela de preferências ########################################################
##
## A tela de preferências permite que o jogador configure o jogo para se adequar
## melhor.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences

screen preferences():

    tag menu

    use game_menu(_("Preferências"), scroll="viewport"):

        vbox:

            hbox:
                box_wrap True

                if renpy.variant("pc") or renpy.variant("web"):

                    vbox:
                        style_prefix "radio"
                        label _("Tela")
                        textbutton _("Janela") action Preference("display", "window")
                        textbutton _("Tela cheia") action Preference("display", "fullscreen")

                vbox:
                    style_prefix "check"
                    label _("Pular")
                    textbutton _("Texto invisível") action Preference("skip", "toggle")
                    textbutton _("Após as escolhas") action Preference("after choices", "toggle")
                    textbutton _("Transições") action InvertSelected(Preference("transitions", "toggle"))

                ## Vboxes adicionais do tipo "radio_pref" ou "check_pref" podem
                ## ser adicionadas aqui para acrescentar outras preferências
                ## definidas pelo criador.

            null height (4 * gui.pref_spacing)

            hbox:
                style_prefix "slider"
                box_wrap True

                vbox:

                    label _("Velocidade do texto")

                    bar value Preference("text speed")

                    label _("Tempo de avanço automático")

                    bar value Preference("auto-forward time")

                vbox:

                    if config.has_music:
                        label _("Volume da música")

                        hbox:
                            bar value Preference("music volume")

                    if config.has_sound:

                        label _("Volume do som")

                        hbox:
                            bar value Preference("sound volume")

                            if config.sample_sound:
                                textbutton _("Teste") action Play("sound", config.sample_sound)


                    if config.has_voice:
                        label _("Volume da voz")

                        hbox:
                            bar value Preference("voice volume")

                            if config.sample_voice:
                                textbutton _("Teste") action Play("voice", config.sample_voice)

                    if config.has_music or config.has_sound or config.has_voice:
                        null height gui.pref_spacing

                        textbutton _("Silenciar tudo"):
                            action Preference("all mute", "toggle")
                            style "mute_all_button"


style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/radio_[prefix_]foreground.png"

style radio_button_text:
    properties gui.text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.text_properties("slider_button")

style slider_vbox:
    xsize 675


## Tela de histórico ###########################################################
##
## Essa é uma tela que exibe o histórico de diálogo para o jogador. Embora não
## haja nada de especial nessa tela, ela precisa acessar o histórico de diálogo
## armazenado em _history_list.
##
## https://www.renpy.org/doc/html/history.html

screen history():

    tag menu

    ## Evite prever essa tela, pois ela pode ser muito grande.
    predict False

    use game_menu(_("Histórico"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0, spacing=gui.history_spacing):

        style_prefix "history"

        for h in _history_list:

            window:

                ## Isso organiza as coisas corretamente se history_height for
                ## None.
                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"
                        substitute False

                        ## Pegue a cor do texto who do caractere, se definido.
                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what:
                    substitute False
                    size 32

        if not _history_list:
            label _("O histórico está vazio.")


## Isso determina quais tags podem ser exibidas na tela de histórico.

define gui.history_allow_tags = { "alt", "noalt", "rt", "rb", "art" }


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    textalign gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    textalign gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5


## Tela de ajuda ###############################################################
##
## Uma tela que fornece informações sobre as combinações de teclas e mouse. Ela
## usa outras telas (keyboard_help, mouse_help e gamepad_help) para exibir a
## ajuda real.

screen help():

    tag menu

    default device = "keyboard"

    use game_menu(_("Ajuda"), scroll="viewport"):

        style_prefix "help"

        vbox:
            spacing 23

            hbox:

                textbutton _("Teclado") action SetScreenVariable("device", "keyboard")
                textbutton _("Mouse") action SetScreenVariable("device", "mouse")

                if GamepadExists():
                    textbutton _("Controle de jogo") action SetScreenVariable("device", "gamepad")

            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "gamepad":
                use gamepad_help


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Avança o diálogo e ativa a interface.")

    hbox:
        label _("Espaço")
        text _("Avança o diálogo sem selecionar opções.")

    hbox:
        label _("Setas")
        text _("Navegua pela interface.")

    hbox:
        label _("Esc")
        text _("Acessa o menu do jogo.")

    hbox:
        label _("Tab")
        text _("Alterna o salto de diálogo.")

    hbox:
        label _("Page Up")
        text _("Volta ao diálogo anterior.")

    hbox:
        label _("Page Down")
        text _("Rola o diálogo para frente.")

    hbox:
        label "H"
        text _("Oculta a interface do usuário.")

    hbox:
        label "S"
        text _("Faz uma captura de tela.")

    hbox:
        label "V"
        text _("Alterna a assistência {a=https://www.renpy.org/l/voicing}auto-voz{/a}.")

    hbox:
        label "Shift+A"
        text _("Abre o menu de acessibilidade.")


screen mouse_help():

    hbox:
        label _("Botão esquerdo do mouse")
        text _("Avança o diálogo e ativa a interface.")

    hbox:
        label _("Botão do meio")
        text _("Oculta a interface do usuário.")

    hbox:
        label _("Botão direito do mouse")
        text _("Acessa o menu do jogo.")

    hbox:
        label _("Roda do mouse para cima")
        text _("Volta o diálogo.")

    hbox:
        label _("Roda do mouse para baixo")
        text _("Avança o diálogo.")


screen gamepad_help():

    hbox:
        label _("Gatilho direito\nBotão A/inferior")
        text _("Avança o diálogo e ativa a interface.")

    hbox:
        label _("Gatilho esquerdo\nOmbro esquerdo")
        text _("Volta o diálogo.")

    hbox:
        label _("Ombro direito")
        text _("Avança o diálogo.")

    hbox:
        label _("D-Pad, bastões")
        text _("Navegua pela interface.")

    hbox:
        label _("Start, Guide, B/Right Button")
        text _("Acessa o menu do jogo.")

    hbox:
        label _("Botão Y/Top")
        text _("Oculta a interface do usuário.")

    textbutton _("Calibrar") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.text_properties("help_button")

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    textalign 1.0


## Confirmar tela ##############################################################
##
## A tela de confirmação é chamada quando Ren'Py quer fazer uma pergunta de sim
## ou não ao jogador.
##
## https://www.renpy.org/doc/html/screen_special.html#confirm

screen confirm(message, yes_action, no_action):

    ## Certifique-se de que outras telas não recebam entrada enquanto essa tela
    ## estiver sendo exibida.
    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/dark_background.png"

    frame:

        vbox:
            xalign 0.5
            yalign 0.5
            spacing 45

            label _(message):
                style "confirm_prompt"
                xalign 0.5

            hbox:
                xalign 0.5
                spacing 150

                textbutton _("Sim") action yes_action
                textbutton _("Não") action no_action

    ## Clique com o botão direito do mouse e escape a resposta "não".
    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    textalign 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.text_properties("confirm_button")


################################################################################
## Mapa
################################################################################

screen game_map():

    $ description, map_buttons, map_data = MAP_SYSTEM[SaveGame["Region"]]
    $ map_layer, frame_x, frame_y, adjust_x, adjust_y = map_data
    $ shift_x = 89

    add "gui/overlay/dark_background.png"

    viewport:
        # Tamanho da janela
        xsize 1820
        ysize 980
        # Põe no canto inferior direito da tela
        xalign 0.5
        yalign 0.5

        # Frame X-1 Y-1
        add "images/maps/[map_layer]_x[str(frame_x - 1)]_y[str(frame_y - 1)].webp":
            xpos 910 - 1000 + adjust_x + shift_x
            ypos 490 - 1000 + adjust_y

        # Frame X0 Y-1
        add "images/maps/[map_layer]_x[str(frame_x)]_y[str(frame_y - 1)].webp":
            xpos 910 + 0    + adjust_x + shift_x
            ypos 490 - 1000 + adjust_y

        # Frame X1 Y-1
        add "images/maps/[map_layer]_x[str(frame_x + 1)]_y[str(frame_y - 1)].webp":
            xpos 910 + 1000 + adjust_x + shift_x
            ypos 490 - 1000 + adjust_y

        # Frame X-1 Y0
        add "images/maps/[map_layer]_x[str(frame_x - 1)]_y[str(frame_y)].webp":
            xpos 910 - 1000 + adjust_x + shift_x
            ypos 490 + 0    + adjust_y

        # Frame X0 Y0 (CENTRAL)
        add "images/maps/[map_layer]_x[str(frame_x)]_y[str(frame_y)].webp":
            xpos 910 + 0    + adjust_x + shift_x
            ypos 490 + 0    + adjust_y

        # Frame X1 Y0
        add "images/maps/[map_layer]_x[str(frame_x + 1)]_y[str(frame_y)].webp":
            xpos 910 + 1000 + adjust_x + shift_x
            ypos 490 + 0    + adjust_y

        # Frame X-1 Y1
        add "images/maps/[map_layer]_x[str(frame_x - 1)]_y[str(frame_y + 1)].webp":
            xpos 910 - 1000 + adjust_x + shift_x
            ypos 490 + 1000 + adjust_y

        # Frame X0 Y1
        add "images/maps/[map_layer]_x[str(frame_x)]_y[str(frame_y + 1)].webp":
            xpos 910 + 0    + adjust_x + shift_x
            ypos 490 + 1000 + adjust_y

        # Frame X1 Y1
        add "images/maps/[map_layer]_x[str(frame_x + 1)]_y[str(frame_y + 1)].webp":
            xpos 910 + 1000 + adjust_x + shift_x
            ypos 490 + 1000 + adjust_y

        # Posição do personagem no mapa
        add "gui/map_position.png":
            xalign 0.55 # Um desvio de +0.05 corresponde a 89 de shift_x
            yalign 0.5

        # Barra superior
        frame:
            xsize 1820     # Tamanho do frame
            padding (0, 5) # Espaço entre os elementos e a borda

            vbox:
                xalign 0.5 # Centraliza o texto

                text "[description!t]":
                    size 30

        # Lista de botões
        for count, b_data in enumerate(map_buttons):
            $ button_text, node_id = b_data

            button:
                action Jump(node_id) # Fecha o mapa e vai ao local selecionado
                padding (0, 0)       # Elimina espaços vazios ao redor do frame
                # Põe no canto inferior direito da tela
                xpos 0
                ypos 53 + 57 * count

                frame:
                    padding (0, 7) # Espaço entre os elementos e a borda
                    xsize 660      # Tamanho do frame

                    vbox:
                        xalign 0.5 # Centraliza o texto

                        text "[button_text!t]":
                            hover_color gui.hover_color
                            color gui.idle_color
                            size 30

        # Botão fechar
        button:
            padding (0, 0)  # Elimina espaços vazios ao redor do frame
            action Return() # Fecha o mapa
            # Põe no canto inferior direito da tela
            xalign 1.0
            yalign 1.0

            frame:
                padding (40, 6) # Espaço entre o texto e a borda

                vbox:
                    text _("Fechar"):
                        hover_color gui.hover_color
                        color gui.idle_color
                        size 36


################################################################################
## Tela de inventário
################################################################################

screen inventory():

    add "gui/overlay/dark_background.png"

    frame:
        # Centraliza o a caixa no meio da tela
        xalign 0.5
        yalign 0.5
        # Tamanho do frame
        xsize 600
        ysize 570
        # Espaço entre os elementos e a borda
        padding (12, 10)

        vbox:
            spacing 20 # Espaço entre os elementos da janela

            text _("Inventário"):
                size 36
                xalign 0.5 # Centraliza o texto

            viewport:
                draggable True        # Permite arrastar
                scrollbars "vertical" # Rolagem vertical
                mousewheel True       # Permite usar a roda do mouse
                ysize 400             # Altura máxima da caixa

                vbox:
                    spacing 10 # Espaço entre os itens
                    # Para cada slot no inventário, recebe o ID do item e sua quantidade
                    for item_id, amount in SaveGame["Inventory"]:
                        hbox:
                            spacing 8 #Espaço o item e o texto
                            add "items/[item_id].webp"

                            vbox:
                                text ITEM_NAME[item_id]:
                                    size 26
                                text "[amount]":
                                    color gui.idle_color
                                    size 24

            button:
                xalign 0.5 # Centraliza o botão
                text _("Fechar"):
                    hover_color gui.hover_color
                    color gui.idle_color
                    size 36
                # Fecha a janela
                action Return()


################################################################################
## Tela de notificação
################################################################################

screen notification(message):

    add "gui/overlay/dark_background.png"

    frame:
        # Centraliza o a caixa no meio da tela
        xalign 0.5
        yalign 0.5
        # Espaço entre os elementos e a borda
        padding (80, 40)

        vbox:
            spacing 20 # Espaço entre os elementos da janela

            text "[message!t]":
                text_align 0.5
                size 36

            button:
                xalign 0.5 # Centraliza o botão
                text _("Fechar"):
                    hover_color gui.hover_color
                    color gui.idle_color
                    size 36
                # Fecha a janela
                action Return()


################################################################################
## Tela de missão
################################################################################

screen mission():
    $ message = eval(SaveGame["Mission"].upper())

    add "gui/overlay/dark_background.png"

    frame:
        # Centraliza o a caixa no meio da tela
        xalign 0.5
        yalign 0.5
        # Espaço entre os elementos e a borda
        padding (80, 40)

        vbox:
            spacing 20 # Espaço entre os elementos da janela

            text "[message!t]":
                text_align 0.5
                size 36

            button:
                xalign 0.5 # Centraliza o botão
                text _("Fechar"):
                    hover_color gui.hover_color
                    color gui.idle_color
                    size 36
                # Fecha a janela
                action Return()


################################################################################
## Tela de loot
################################################################################

screen loot(item_list):

    add "gui/overlay/dark_background.png"

    frame:
        # Centraliza o a caixa no meio da tela
        xalign 0.5
        yalign 0.5
        # Tamanho do frame
        xsize 600
        ysize 570
        # Espaço entre os elementos e a borda
        padding (12, 10)

        vbox:
            spacing 20 # Espaço entre os elementos da janela

            text _("Itens obtidos"):
                size 36
                xalign 0.5 # Centraliza o texto

            viewport:
                draggable True        # Permite arrastar
                scrollbars "vertical" # Rolagem vertical
                mousewheel True       # Permite usar a roda do mouse
                ysize 400             # Altura máxima da caixa

                vbox:
                    spacing 16 # Espaço entre os itens
                    # Para cada item no loot, recebe o ID do item e sua quantidade
                    for item_id, amount in item_list:
                        hbox:
                            spacing 6 #Espaço o item e o texto
                            add "items/[item_id].webp"

                            vbox:
                                text ITEM_NAME[item_id]:
                                    size 26
                                text "[amount]":
                                    color gui.idle_color
                                    size 24

            button:
                xalign 0.5 # Centraliza o botão
                text _("Fechar"):
                    hover_color gui.hover_color
                    color gui.idle_color
                    size 36
                # Fecha a janela
                action Return()


################################################################################
## Variantes do celular
################################################################################

style pref_vbox:
    variant "medium"
    xsize 675

## Como o mouse pode não estar presente, substituímos o menu rápido por uma
## versão que usa menos botões e maiores, que são mais fáceis de tocar.
screen quick_menu():
    variant "touch"

    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Voltar") action Rollback()
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Inventário") action ShowMenu('inventory')
            textbutton _("Missão") action ShowMenu('mission')
            textbutton _("Salvar") action ShowMenu('save')
            textbutton _("Menu") action ShowMenu()


style window:
    variant "small"
    background "gui/phone/textbox.png"

style radio_button:
    variant "small"
    foreground "gui/phone/button/radio_[prefix_]foreground.png"

style check_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 420

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 600

style bar:
    variant "small"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "small"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "small"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "small"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "small"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "small"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_vbox:
    variant "small"
    xsize None

style slider_slider:
    variant "small"
    xsize 900
