################################################################################
## Batalha contra um javali
################################################################################

label battle_enubethrae:

    $ allow_loot = False

    python:
        possible_loot = [# Loot 01 --> 1 Costelas de javali
                         [["item_qwyrsywbej", 1]],
                         # Loot 02 --> 1 Costelas de javali, 1 Presa de javali
                         [["item_qwyrsywbej", 1], ["item_ilcbtqusbu", 1]],
                         # Loot 03 --> 2 Costelas de javali
                         [["item_qwyrsywbej", 2]]
                        ]

    $ item_list = renpy.random.choice(possible_loot)

    $ first_round = ["A01", "A02", "A03"]
    $ inter_round = ["A01", "A02", "A03", "A04", "A05", "A06", "A07"]
    $ final_round = ["A01", "A02", "A03", "A04"]

    # ==========================================================================
    $ action = renpy.random.choice(first_round)

    if action == "A01":

        show boar

        voice "audio/voices/voice_llgylxidhe.ogg"
        "De repente, um grunhido profundo ecoa pela mata e surge, diante de Taragan, um enorme javali."

        hide boar

    if action == "A02":

        show boar

        voice "audio/voices/voice_idwjwvksns.ogg"
        "O silêncio da floresta se quebra com o estalo de galhos pesados sendo esmagados sob patas firmes. E um grande javali surge."

        hide boar

    if action == "A03":

        show boar

        voice "audio/voices/voice_tradnvpank.ogg"
        "Taragan é surpreendido por um javali. Seus dentes curvos e amarelados, aparentavam ser tão afiados quanto uma ponta de lança."

        hide boar

    # ==========================================================================
    $ count = 1

    while count <= 3:
        $ count += 1
        $ action = renpy.random.choice(inter_round)

        if action == "A01":

            show taragan

            voice "audio/voices/voice_ttdldomhjd.ogg"
            "Taragan firma a posição, respira fundo e se prepara para a investida do javali."

            hide taragan

            show boar

            voice "audio/voices/voice_jslewbrine.ogg"
            "Com um olhar fixo, o javali se posiciona para o ataque."

            hide boar

            show taragan

            voice "audio/voices/voice_aqwjtrejkj.ogg"
            "O aventureiro bloqueia o ataque com sua espada, empurrando o animal para trás."

            hide taragan

        if action == "A02":

            show boar

            voice "audio/voices/voice_ynwvajbkyb.ogg"
            "O javali dispara como um projétil vivo, e o barulho da colisão reverbera na armadura do aventureiro."

            hide boar

            show taragan

            voice "audio/voices/voice_vifybyzvow.ogg"
            "Taragan perde um pouco do equilíbrio, mas se mantém de pé."

            hide taragan

        if action == "A03":

            show boar

            voice "audio/voices/voice_bpjzxsrytp.ogg"
            "O javali ataca, empurrando o aventureiro dois passos para trás."

            hide boar

            show taragan

            voice "audio/voices/voice_xyabmbefxh.ogg"
            "Taragan se reposiciona e espera por uma brecha na defesa de seu adversário."

            hide taragan

        if action == "A04":

            show taragan

            voice "audio/voices/voice_kubgcoboge.ogg"
            "Taragan gira a sua espada em um arco descendente, mirando o ombro musculoso do animal. O aço corta o ar e inflige um golpe certeiro."

            hide taragan

            show boar

            voice "audio/voices/voice_rxyczcemmi.ogg"
            "O javali solta um urro de dor e fúria, respingando sangue pelo chão da floresta."

            hide boar

        if action == "A05":

            show boar

            voice "audio/voices/voice_sasyglykzc.ogg"
            "O javali avança, bufando e chutando a terra com suas patas."

            hide boar

            show taragan

            voice "audio/voices/voice_ygzipfbhiy.ogg"
            "Taragan avança rapidamente e golpeia o animal."

            hide taragan

        if action == "A06":

            show taragan

            voice "audio/voices/voice_arpigyxeqd.ogg"
            "Sem perder tempo, Taragan avança com sua espada e golpeia o javali na cabeça."

            hide taragan

            show boar

            voice "audio/voices/voice_agvgsbuevp.ogg"
            "O animal sai cambaleando enquanto o aventureiro toma fôlego."

            hide boar

        if action == "A07":

            show boar

            voice "audio/voices/voice_tzjfyynhpa.ogg"
            "Enfurecido, o animal gira em um ataque lateral, tentando atingir as pernas do aventureiro com suas presas afiadas."

            hide boar

            show taragan

            voice "audio/voices/voice_tgnslrhbgt.ogg"
            "Taragan, por meio de um reflexo, consegue desviar de grande parte do ataque, levando somente um arranhão."

            hide taragan

    # ==========================================================================
    $ action = renpy.random.choice(final_round)

    if action == "A01":

        show boar

        voice "audio/voices/voice_leugwfxmkt.ogg"
        "O javali, por sua vez, não recua. Avança com agilidade."

        hide boar

        show taragan

        voice "audio/voices/voice_etwmiboqpj.ogg"
        "Taragan encontra um ponto fraco na defesa de seu adversário e o golpeia com toda força, dando fim à batalha."

        hide taragan

        $ allow_loot = True

    if action == "A02":

        show boar

        voice "audio/voices/voice_thiijmuhvq.ogg"
        "O javali começava a demonstrar cansaço."

        hide boar

        show taragan

        voice "audio/voices/voice_bzklmadlgp.ogg"
        "Taragan avança rapidamente, infligindo um poderoso golpe no pescoço de seu adversário."

        hide taragan

        $ allow_loot = True

    if action == "A03":

        show boar

        voice "audio/voices/voice_jjzezyliqm.ogg"
        "O javali já não mais demonstrava o vigor do início da batalha."

        hide boar

        show taragan

        voice "audio/voices/voice_ovumxgpsjh.ogg"
        "Em um movimento calculado, Taragan atinge seu adversário na cabeça, dando fim à batalha."

        hide taragan

        $ allow_loot = True

    if action == "A04":

        show boar

        voice "audio/voices/voice_pynhsqukft.ogg"
        "O javali, já ferido e cambaleante, prepara uma última investida, reunindo todas as suas forças."

        hide boar

        show taragan

        voice "audio/voices/voice_yfpigxsarw.ogg"
        "Taragan desvia e usa sua espada para disferir o golpe final."

        hide taragan

        $ allow_loot = True

    # ==========================================================================
    if allow_loot:
        $ Inventory.add_item_list(item_list)
        call screen loot(item_list)

    return


