################################################################################
## Batalha contra um esqueleto
################################################################################

label battle_teecjcvrky:

    $ allow_loot = False

    python:
        possible_loot = [# Loot 01 --> 2 Moeda de ouro
                         [["item_qzxrbcyila", 2]],
                         # Loot 02 --> 1 Moeda de ouro
                         [["item_qzxrbcyila", 1]],
                         # Loot 03 --> 1 Moeda de ouro, 2 Moeda de prata
                         [["item_qzxrbcyila", 1], ["item_mkivsiqpdo", 2]],
                         # Loot 04 --> 1 Moeda de ouro, 1 Moeda de prata
                         [["item_qzxrbcyila", 1], ["item_mkivsiqpdo", 1]],
                         # Loot 05 --> 1 Moeda de ouro, 1 Moeda de prata, 1 Moeda de bronze
                         [["item_qzxrbcyila", 1], ["item_mkivsiqpdo", 1], ["item_gliqntrnzu", 1]],
                         # Loot 06 --> 2 Moeda de prata
                         [["item_mkivsiqpdo", 2]],
                         # Loot 07 --> 3 Moeda de bronze
                         [["item_gliqntrnzu", 3]]
                        ]

    $ item_list = renpy.random.choice(possible_loot)

    $ first_round = ["A01", "A02"]
    $ inter_round = ["A01", "A02", "A03"]
    $ final_round = ["A01", "A02"]

    # ==========================================================================
    $ action = renpy.random.choice(first_round)

    if action == "A01":

        show taragan

        voice "audio/voices/voice_gqlbbczrif.ogg"
        "Taragan observa atentamente à movimentação de um esqueleto, enquanto tenta imaginar como um amontoado de ossos é capaz de se mexer."

        voice "audio/voices/voice_gpssciuulo.ogg"
        "Ele respira fundo e avança em direção a seu inimigo."

        hide taragan

        show skeleton

        voice "audio/voices/voice_ffiqsybcbz.ogg"
        "O esqueleto nota a presença do aventureiro e se põe em posição de ataque."

        hide skeleton

    if action == "A02":

        show taragan

        voice "audio/voices/voice_dtijydqkyf.ogg"
        "Taragan anda, com passos lentos, para não ser percebido. Mas acaba gerando barulho ao pisar em um graveto seco e chama a atenção de um esqueleto."

        hide taragan

        show skeleton

        voice "audio/voices/voice_idzzsguraa.ogg"
        "O esqueleto avança rapidamente, deixando o aventureiro assustado."

        hide skeleton

    # ==========================================================================
    $ count = 1

    while count <= 3:
        $ count += 1
        $ action = renpy.random.choice(inter_round)

        if action == "A01":

            show taragan

            voice "audio/voices/voice_kcabdnrfuo.ogg"
            "Taragan ataca com sua espada, desferindo um golpe firme em seu adversário."

            hide taragan

            show skeleton

            voice "audio/voices/voice_fzcjcawqsp.ogg"
            "O esqueleto perde um pouco de equilíbrio e acaba por ter algumas costelas quebradas."

            voice "audio/voices/voice_euvgwhosso.ogg"
            "Mesmo assim, avança em direção ao aventureiro desferindo um soco. Mas sua mão frágil não causa muito dano."

            hide skeleton

        if action == "A02":

            show taragan

            voice "audio/voices/voice_bvgeelptep.ogg"
            "O aventureiro avança para cima do inimigo golpeando o mesmo com um soco."

            hide taragan

            show skeleton

            voice "audio/voices/voice_aeunkurmxl.ogg"
            "Porém, o esqueleto consegue bloquear e revidar com um chute."

            hide skeleton

            show taragan

            voice "audio/voices/voice_lvylzqkmqn.ogg"
            "O coração de Taragan começa a bater mais rápido e sua respiração se torna mais ofegante."

            hide taragan

        if action == "A03":

            show taragan

            voice "audio/voices/voice_hhonhsgsev.ogg"
            "Taragan dá um passo para trás e se põe em guarda."

            hide taragan

            show skeleton

            voice "audio/voices/voice_ttbgsmatsv.ogg"
            "O esqueleto avança com passos lentos."

            hide skeleton

    # ==========================================================================
    $ action = renpy.random.choice(final_round)

    if action == "A01":

        show taragan

        voice "audio/voices/voice_cakjzwgeej.ogg"
        "Taragan segura firmemente sua espada, dá uma investida em direção ao esqueleto e golpeia com toda sua força. Fazendo o mesmo se tornar uma mera pilha de ossos."

        hide taragan

        $ allow_loot = True

    if action == "A02":

        show taragan

        voice "audio/voices/voice_ycutuutfen.ogg"
        "Com um impulso, Taragan salta e dá um chute na cabeça de seu adversário. Fazendo a mesma voar para longe."

        hide taragan

        $ allow_loot = True

    # ==========================================================================
    if allow_loot:
        $ Inventory.add_item_list(item_list)
        call screen loot(item_list)

    return


