################################################################################
## Variáveis de savegame
################################################################################

default SaveGame = {
    # Inventário [["ID", Quantidade], ... ]
    "Inventory": [],
    # Lista de nodes de região que foram coletadas recentemente (ruínas)
    "Collected": [],
    # Missão em andamento
    "Mission": "mission_ewtyxrvmgu", # Missão inicial
    # Região em que o personagem se encontra
    "Region": "node_drnrmbydhf",     # Posição inicial (Floresta de Pinheiros)
    # Recebe o último local em que o personagem esteve
    "Place": ""
    }


################################################################################
## Constantes
################################################################################

# ----------------- QUANTIDADE DE REGIÕES COM LOOT DISPONÍVEL ------------------
define LOOT_SPOT = 2
# ------------------------------ ESTILOS DE TEXTO ------------------------------
# Estilo do texto de expressão (esqueda)
define BRA = "{font=Lora-MediumItalic.ttf}{color=#aaaaaa}{size=34}{i}("
# Estilo do texto de expressão (direita)
define KET = "){/i}{/size}{/color}{/font}\n"


################################################################################
## Itens
################################################################################

init python:
    # Dicionário de nomes de itens
    ITEM_NAME = {"item_zlqttdhddm": _("Algodão"),
                 "item_gxwrbjwiee": _("Carretel de linha"),
                 "item_oqwcvqlski": _("Carvão mineral"),
                 "item_wqwrbbmsof": _("Corda"),
                 "item_qwyrsywbej": _("Costelas de javali"),
                 "item_cdhjomcprh": _("Costelas de javali assadas"),
                 "item_kpvstyutky": _("Couro curtido"),
                 "item_fsfjftrbyx": _("Livro em branco"),
                 "item_coecjsytav": _("Machado"),
                 "item_gliqntrnzu": _("Moeda de bronze"),
                 "item_qzxrbcyila": _("Moeda de ouro"),
                 "item_mkivsiqpdo": _("Moeda de prata"),
                 "item_vpabaiksuz": _("Minério de ferro"),
                 "item_obpozsufdn": _("Minério de ouro"),
                 "item_hostxccvsy": _("Minério de prata"),
                 "item_feklipetja": _("Pão"),
                 "item_nhegrtghve": _("Papel"),
                 "item_ttbuadlsri": _("Papiro"),
                 "item_mmbbhesudh": _("Pedra"),
                 "item_uulfapothq": _("Pele de lobo"),
                 "item_gmzrpzkmlz": _("Pergaminho do piromante"),
                 "item_hdgpfaslzo": _("Pernil de cordeiro assado"),
                 "item_tmymusbmev": _("Poção de cura"),
                 "item_ilcbtqusbu": _("Presa de javali"),
                 "item_zfjygrzpjg": _("Presa de lobo"),
                 "item_zidawelxik": _("Tecido"),
                 "item_trfadziqhc": _("Tronco de pinheiro")
                }

    # Lista de itens encontrados nas ruínas com sua respectiva quantidade máxima permitida
    RANDOM_ITEMS = [# [Item, Quantidade_Máxima]
                    ["item_zlqttdhddm",  5], # Algodão
                    ["item_gxwrbjwiee",  2], # Carretel de linha
                    ["item_oqwcvqlski",  3], # Carvão mineral
                    ["item_wqwrbbmsof",  1], # Corda
                    ["item_kpvstyutky",  1], # Couro curtido
                    ["item_fsfjftrbyx",  1], # Livro em branco
                    ["item_vpabaiksuz",  3], # Minério de ferro
                    ["item_obpozsufdn",  1], # Minério de ouro
                    ["item_hostxccvsy",  1], # Minério de prata
                    ["item_nhegrtghve", 10], # Papel
                    ["item_ttbuadlsri",  3], # Papiro
                    ["item_mmbbhesudh",  2], # Pedra
                    ["item_uulfapothq",  1], # Pele de lobo
                    ["item_tmymusbmev",  1], # Poção de cura
                    ["item_ilcbtqusbu",  1], # Presa de javali
                    ["item_zfjygrzpjg",  1], # Presa de lobo
                    ["item_zidawelxik",  1], # Tecido
                    ["item_trfadziqhc",  3]  # Tronco de pinheiro
                   ]


################################################################################
## Sistema de mapas
################################################################################

init python:
    # "node_de_região": [legenda, botões, dados]
    MAP_SYSTEM = {"node_svruvlhrox": [_("Bosque Sombrio - Continente de Lamanki"),
                                       [[_("Viajar para a Floresta de Pinheiros"), "node_drnrmbydhf"]], # [Nome, ID]
                                       ["surface", 0, 0, -387, -437]], # [map_layer, frame_x, frame_y, adjust_x, adjust_y]

                  "node_jihzthkkgk": [_("Vila dos Pinheiros - Continente de Lamanki"),
                                       [[_("Viajar para a Floresta de Pinheiros"), "node_drnrmbydhf"],
                                        [_("Viajar para a Floresta de Tamirkan"), "node_pomrzphsai"]],
                                       ["surface", 0, 0, -562, -362]],

                  "node_drnrmbydhf": [_("Floresta de Pinheiros - Continente de Lamanki"),
                                       [[_("Viajar para o Bosque Sombrio"), "node_svruvlhrox"],
                                        [_("Viajar para a Vila dos Pinheiros"), "node_jihzthkkgk"]],
                                       ["surface", 0, 0, -487, -537]],

                  "node_pomrzphsai": [_("Floresta de Tamirkan - Continente de Lamanki"),
                                       [[_("Viajar para a Vila dos Pinheiros"), "node_jihzthkkgk"],
                                        [_("Viajar para Tamirkan"), "node_unasilcgqg"]],
                                       ["surface", 0, 0, -462, -262]],

                  "node_unasilcgqg": [_("Tamirkan - Continente de Lamanki"),
                                       [[_("Viajar para a Floresta de Tamirkan"), "node_pomrzphsai"]],
                                       ["surface", 0, 0, -512, -137]]
                 }


################################################################################
## Inventário
################################################################################

init python:
    class Inventory(object):

        def sort_by_amount():
            """Ordena a lista de itens do inventário pela quantidade."""
            SaveGame["Inventory"].sort(key=lambda x: x[1], reverse=True) # Ordena a lista de itens pelo segundo item das sublistas, do maior para o menor

        def there_are_item(item_id, minimum):
            """Verifica se há quantidade suficiente de um determinado item no inventário."""
            inventory = SaveGame["Inventory"]

            for slot, amount in inventory:
                if slot == item_id:
                    if amount >= minimum:
                        return True

        def add_item(item_id, to_add):
            """Adiciona um ou mais itens, de um tipo, no inventário."""
            inventory = SaveGame["Inventory"]
            updated_list = [] # Recebe o inventário atualizado
            exists = False # Recebe verdadeiro caso exista no inventário o item a ser adicionado

            for slot, amount in inventory:
                if slot == item_id:
                    exists = True
                    updated_list.append([slot, amount + to_add])
                else:
                    updated_list.append([slot, amount])

            # Se o item não existe no inventário
            if not exists:
                # Adiciona o item em um novo slot
                updated_list.append([item_id, to_add])

            # Salva o novo inventário
            SaveGame["Inventory"] = updated_list

        def remove_item(item_id, to_remove):
            """Remove um ou mais itens, de um tipo, no inventário."""
            inventory = SaveGame["Inventory"]
            updated_list = [] # Recebe o inventário atualizado

            for slot, amount in inventory:
                if slot == item_id:
                    if amount > to_remove: # Se a quantidade disponível for maior que a quantidade a ser removida
                        updated_list.append([slot, amount - to_remove])
                else:
                    updated_list.append([slot, amount])

            # Salva o novo inventário
            SaveGame["Inventory"] = updated_list

        def there_are_item_list(item_list):
            """Verifica se há quantidade suficiente, no inventário, de uma determinada lista de itens."""

            # Armazena um valor verdadeiro ou falso para cada item da lista encontrado em quantidade sufuciente
            exists = []

            for item_id, amount in item_list:
                exists.append(Inventory.there_are_item(item_id, amount))

            return all(exists) # Retorna verdadeiro se todos os itens existem em quantidade suficiente

        def add_item_list(item_list):
            """Adiciona uma lista de itens no inventário."""

            for item_id, amount in item_list:
                Inventory.add_item(item_id, amount)

            Inventory.sort_by_amount() # Ordena o inventário

        def remove_item_list(item_list):
            """Remove uma lista de itens no inventário."""

            for item_id, amount in item_list:
                Inventory.remove_item(item_id, amount)

            Inventory.sort_by_amount() # Ordena o inventário


################################################################################
## Verifica se o personagem pode executar certas ações
################################################################################

init python:
    class Allow(object):

        def collect_wood():
            """Verifica se há um machado no inventário."""

            item_list = [["item_coecjsytav", 1]] # Um machado
            exists = Inventory.there_are_item_list(item_list)

            if exists:
                return True
            else:
                renpy.call_screen("notification", _("Você precisa de um machado."))


################################################################################
## Lida com o sistema aleatório de loot das ruínas
################################################################################

init python:
    class RandomLoot(object):

        def get_item():

            # Escolhe um item aletório
            name, max_amount = renpy.random.choice(RANDOM_ITEMS)
            # Sorteia a quantidade entre 1 e a máxima permitida
            amount = renpy.random.randint(1, max_amount)
            # Empacota o item
            item = [name, amount]

            return item

        def get_item_list():

            # Lista de itens
            item_list = []
            # Sorteia de 1 a 3 slots para serem ocupados pelos itens
            slots = renpy.random.randint(1, 3)

            # Para cada slot
            for i in range(0, slots):
                # Recebe um item aleatório com quantidade aleatória
                item = RandomLoot.get_item()
                # Adiciona o item à lista
                item_list.append(item)

            return item_list

        def get_loot():

            # Recebe a lista de nodes de região que tiveram algum loot coletado em ruínas recentemente
            collected_nodes = SaveGame["Collected"]
            # Recebe a região em que o personagem se encontra
            region = SaveGame["Region"]

            # Se a região não está na lista de nodes coletados
            if not region in collected_nodes:
                # Adiciona a região atual à lista de nodes coletados
                collected_nodes.append(region)

                # Se houver mais nodes coletados ou igual à quantidade de nodes disponíveis
                if len(collected_nodes) >= LOOT_SPOT:
                    # Remove a região mais antiga da lista de nodes coletados
                    del collected_nodes[0]
                    # Salva a nova lista
                    SaveGame["Collected"] = collected_nodes

                # Recebe a lista de itens do loot
                item_list = RandomLoot.get_item_list()

                return item_list


